package de.bebagoe.util.coll;
import java.util.Arrays;

public class SimpleSortedList<E extends Comparable<E>> {
	private E[] elements;
	private final static int DEF_INIT_SIZE = 16;
	private int initSize;
	private int size;

	@SuppressWarnings("unchecked")
	// Casting erforderlich, weil kein Array vom Typ E erstellt werden kann.
	// Das Array elements kann nur Objekte vom Typ E enthalten.
	public SimpleSortedList(int len) {
        if (len <= 0)
            throw new IllegalArgumentException("Die initiale Größe muss positiv sein.");
        initSize = len;
        elements = (E[]) new Comparable[len];
        super();
	}

	@SuppressWarnings("unchecked")
	// Casting erforderlich, weil kein Array vom Typ E erstellt werden kann.
	// Das Array elements kann nur Objekte vom Typ E enthalten.
	public SimpleSortedList() {
        initSize = DEF_INIT_SIZE;
        elements = (E[]) new Comparable[DEF_INIT_SIZE];
        super();
	}

	// Diese Methode wurde durch Paul Frischknecht entscheidend verbessert.
	public void add(E element) {
		if (size == elements.length)
			elements = Arrays.copyOf(elements, elements.length + initSize);
		int i;
		for (i = size-1; i >= 0 && element.compareTo(elements[i]) < 0; i--)
			elements[i+1] = elements[i];
		elements[i+1] = element;
		size++;
	}

	public E get(int index) {
		if (index >= 0 && index < size)
			return elements[index];
		else
			return null;
	}

	public int size() {return size;}

	public int capacity() {return elements.length;}
}
